<?php

/**
 * This is the model class for table "ZlecenieFirmy".
 *
 * The followings are the available columns in table 'ZlecenieFirmy':
 * @property double $id
 * @property double $idZlecenia
 * @property double $idFirmy
 * @property string $czasPodjecia
 * @property string $czasRozpoczecia
 * @property string $czasZakonczenia
 * @property double $idOdpowiedzi
 * @property string $czasPrzypisania	// -> czas w ktorym zlecenie przypisano pracownikowi
 * @property int    $idUcznia
 * @property string $odpowiedz
 * @property int    $idFaktury
 * @property int    $idOplaty
 * @property int    $idKontrahenta
 * @property int    $idGrupyPrzetargowej
 * @property int    $idPracownika
 *
 * @property Firma             $idFirmy0
 * @property Zlecenie          $idZlecenia0
 * @property ZlecenieOdpowiedz $idOdpowiedzi0
 * @property Uzytkownik        $uczen
 * @property Faktury           $faktura
 * @property Oplaty            $oplata
 * @property Kontrahent        $kontrahent
 * @property PrzetargGrupa     $tenderGroup
 * @property Pracownik         $worker
 */
class ZlecenieFirmy extends CActiveRecord
{
	const TASK_FAILED = 0;	//zakończone i nieudane
	const TASK_SUCCESS = 1;	//zakończone i udane
	const TASK_NOTSET = 2;	//trwa lub oczekuje

	public $dziedzina;
	public $poziom;
	public $kategoria;

	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return ZlecenieFirmy the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'ZlecenieFirmy';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		return array(
			array('idZlecenia', 'required'),
			array('idZlecenia, idFirmy, idOdpowiedzi, idUcznia, idFaktury,
				idOplaty, idKontrahenta, idGrupyPrzetargowej, idPracownika', 'numerical'),
			array('czasPodjecia, czasRozpoczecia, czasZakonczenia', 'safe'),
			array('odpowiedz', 'length', 'max' => 2000),

			array('id, idZlecenia, idFirmy, czasPodjecia, czasRozpoczecia, czasZakonczenia,
				idOdpowiedzi, czasPrzypisania, idUcznia, odpowiedz, dziedzina, poziom,
				kategoria, idOplaty, idFaktury, idUcznia, idKontrahenta, idGrupyPrzetargowej,
				idPracownika', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		return array(
			'idFirmy0'=>array(self::BELONGS_TO, 'Firma', 'idFirmy'),
			'idZlecenia0'=>array(self::BELONGS_TO, 'Zlecenie', 'idZlecenia'),
			'idOdpowiedzi0'=>array(self::BELONGS_TO, 'ZlecenieOdpowiedz', 'idOdpowiedzi'),
			'uczen'=>array(self::BELONGS_TO, 'Uzytkownik', 'idUcznia'),
			'faktura'=>array(self::BELONGS_TO, 'Faktury', 'idFaktury'),
			'oplata'=>array(self::BELONGS_TO, 'Oplaty', 'idOplaty'),
			'kontrahent'=>array(self::BELONGS_TO, 'Kontrahent', 'idKontrahenta'),
			'tenderGroup'=>array(self::BELONGS_TO, 'PrzetargGrupa', 'idGrupyPrzetargowej'),
			'worker'=>array(self::BELONGS_TO, 'Pracownik', 'idPracownika'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id'=>Yii::t('ZlecenieFirmy', 'id'),
			'idZlecenia'=>Yii::t('ZlecenieFirmy', 'idZlecenia'),
			'idFirmy'=>Yii::t('ZlecenieFirmy', 'idFirmy'),
			'czasPodjecia'=>Yii::t('ZlecenieFirmy', 'czasPodjecia'),
			'czasRozpoczecia'=>Yii::t('ZlecenieFirmy', 'czasRozpoczecia'),
			'czasZakonczenia'=>Yii::t('ZlecenieFirmy', 'czasZakonczenia'),
			'idOdpowiedzi'=>Yii::t('ZlecenieFirmy', 'idOdpowiedzi'),
			'czasPrzypisania'=>Yii::t('ZlecenieFirmy', 'czasPrzypisania'),
			'idUcznia'=>Yii::t('ZlecenieFirmy', 'Uczeń'),
			'odpowiedz'=>Yii::t('ZlecenieFirmy', 'Udzielona odpowiedź'),
			'idFaktury'=>Yii::t('ZlecenieFirmy', 'Faktura'),
			'idOplaty'=>Yii::t('ZlecenieFirmy', 'Oplaty'),
			'idKontrahenta'=>Yii::t('Zlecenie', 'Kontrahent'),
			'idGrupyPrzetargowej'=>Yii::t('Zlecenie', 'Grupa przetargowa'),
			'idPracownika'=>Yii::t('Zlecenie', 'Pracownik'),
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		$criteria = new CDbCriteria;

		$criteria->compare('"t"."id"', $this->id);
		$criteria->compare('"t"."idZlecenia"', $this->idZlecenia);
		$criteria->compare('"t"."idFirmy"', $this->idFirmy);
		$criteria->compare('"t"."czasPodjecia"', $this->czasPodjecia, true);
		$criteria->compare('"t"."czasRozpoczecia"', $this->czasRozpoczecia, true);
		$criteria->compare('"t"."czasZakonczenia"', $this->czasZakonczenia, true);
		$criteria->compare('"t"."idOdpowiedzi"', $this->idOdpowiedzi);
		$criteria->compare('"t"."czasPrzypisania"', $this->czasPrzypisania);
		$criteria->compare('"t"."idUcznia"', $this->idUcznia);
		$criteria->compare('LOWER("t"."odpowiedz")', strtolower($this->odpowiedz), true);
		$criteria->compare('"t"."idFaktury"', $this->idFaktury);
		$criteria->compare('"t"."idOplaty"', $this->idOplaty);

		$criteria->compare('LOWER("idZlecenia0"."dziedzina")', strtolower($this->dziedzina));
		$criteria->compare('LOWER("idZlecenia0"."poziom")', strtolower($this->poziom), true);
		$criteria->compare('LOWER("idZlecenia0"."kategoria")', strtolower($this->kategoria));

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	public function getIsOpen()
	{
		return !empty($this->czasRozpoczecia) && empty($this->czasZakonczenia);
	}

	public function getIsDone()
	{
		return !empty($this->czasZakonczenia) && !empty($this->idOdpowiedzi);
	}

	public function getIsWrong()
	{
		return !empty($this->czasZakonczenia) && empty($this->idOdpowiedzi);
	}

	public function getIsFinished()
	{
		return !empty($this->czasZakonczenia);
	}

	public function refuse()
	{
		//usun fakturę
		if (!empty($this->idFaktury))
		{
			if (!$this->faktura->delete())
				throw new Exception('Nie można unieważnić faktury.');
			$this->idFaktury = null;
		}

		//usun przelew
		if (!empty($this->idOplaty))
		{
			if (!$this->oplata->delete())
				throw new Exception('Nie można cofnąć przelewu.');
			$this->idOplaty = null;
		}

		//usun pieniądze
		$wartosc = empty($this->faktura) ? 0 : (float)$this->faktura->cenaBrutto;
		$this->idFirmy0->stanKonta = (float)$this->idFirmy0->stanKonta - $wartosc;
		if (!$this->idFirmy0->save(false))
			throw new Exception('Nie można zaktualizować stanu konta.');

		//usun punkty
		$punkty = DziedzinaFirmy::model()->find(
			'"t"."idFirmy" = :idFirmy AND "t"."idDziedziny" = :idDziedziny', array(
				':idFirmy' => $this->idFirmy,
				':idDziedziny' => $this->idZlecenia0->idDziedziny
			)
		);
		if (!empty($punkty))
		{
			$punkty->punkty = (float)$punkty->punkty - $this->idZlecenia0->scoreForOrder;
			if (!$punkty->save())
				throw new Exception('Nie można zaktualizować punktów.');
		}
		else
			throw new Exception('Nie można zlokalizować punktów dziedziny.');

		$this->idOdpowiedzi = null;
	}

	protected function transferPayment()
	{
		$faktura = new Faktury;
		$faktura->czyKoszt = 0;
		$faktura->idFirmy = $this->idFirmy;
		$faktura->idKontrahenta = $this->idKontrahenta;
		$faktura->dataWystawienia = new CDbExpression('SYSDATE');
		$faktura->opis = 'Wykonanie zlecenia z ' . $this->idZlecenia0->dziedzina->nazwa
			. ' poziom ' . strtolower($this->idZlecenia0->poziomStr);
		$faktura->nrFaktury = 'F/' . date('Y/m/d/', time()) . rand(0, 9) . rand(0, 9) . rand(0, 9);
		$faktura->stawkaVat = ParametryGry::getFloat('PODATEK_VAT', 0.23);
		$faktura->cenaNetto = $this->idZlecenia0->cena;
		$faktura->dataPlatnosci = new CDbExpression('SYSDATE');
		$faktura->save(false);
		$this->idFaktury = $faktura->id;

		$przelew = new Oplaty;
		$przelew->rodzajOplaty = Oplaty::TYPE_TASK_PAYMENT;
		$przelew->idFirmy = $this->idFirmy;
		$przelew->idKontrahenta = $this->idKontrahenta;
		$przelew->tytul = 'Opłata za fakturę ' . $faktura->nrFaktury;
		$przelew->wartosc = $faktura->cenaBrutto;
		$przelew->czas = new CDbExpression('SYSDATE');
		$przelew->save(false);
		$this->idOplaty = $przelew->id;

		$this->idFirmy0->stanKonta = (float)$this->idFirmy0->stanKonta + (float)$przelew->wartosc;
		$this->idFirmy0->save(false);

		Yii::app()->user->setState('bankrut', $this->idFirmy0->stanKonta <= 0);
	}

	public function getBookNotes($companyId) {
		$sql = '/* Pobieramy źle rozwiązane pojedyncze zlecenia */
                        SELECT "k"."nazwa", ("f"."nrFaktury" || \' \' || "d"."nazwa" || \' - \' || (CASE "z"."poziom" WHEN 1 THEN \'Łatwe\'  WHEN 2 THEN \'Trudne\'  WHEN 3 THEN \'Bardzo trudne\' END) || \' - \' || "z"."kategoria") as "zlecenie", ("z"."kara"/100 * "z"."cena") as "kwotaKary", to_char("t"."czasZakonczenia", \'YYYY/MM/DD\') as "czasZakonczenia", 0 as "przetarg", "t"."id" as "id"
			FROM "ZlecenieFirmy" "t"
			LEFT JOIN "Kontrahent" "k"ON "k"."id" = "t"."idKontrahenta"
			LEFT JOIN "Zlecenie" "z" ON "z"."id" = "t"."idZlecenia"
			LEFT JOIN "Faktury" "f" ON "f"."id" = "t"."idFaktury"
			LEFT JOIN "Dziedzina" "d" ON "d"."id" = "z"."idDziedziny"
			WHERE "t"."idFirmy" = '.$companyId.' AND "t"."czasPodjecia" IS NOT NULL AND
								"t"."czasZakonczenia" IS NOT NULL AND "t"."idOdpowiedzi" IS NULL AND "t"."idGrupyPrzetargowej" = null
			UNION ALL
                        /* Dołączamy źle rozwiązane przetargi */
			SELECT "nazwa", "zlecenie", "kwotaKary", "czasZakonczenia", "przetarg", "id"
			FROM  (

			/* Zlecenia z przetargów źle zrobionych z policzoną sumą kar gurpując po idGrupyPrzetargowej */
				SELECT DISTINCT "idGrupyPrzetargowej",
					first_value("nazwa") over (partition by "idGrupyPrzetargowej" order by "nazwa" asc) as "nazwa",
					first_value("zlecenie") over (partition by "idGrupyPrzetargowej" order by "zlecenie" asc) as "zlecenie",
					first_value("kwotaKary") over (partition by "idGrupyPrzetargowej" order by "kwotaKary" asc) as "kwotaKary",
					first_value("przetarg") over (partition by "idGrupyPrzetargowej" order by "przetarg" asc) as "przetarg",
					first_value("czasZakonczenia") over (partition by "idGrupyPrzetargowej" order by "przetarg" asc) as "czasZakonczenia",
					first_value("id") over (partition by "idGrupyPrzetargowej" order by "id" asc) as "id"
				 FROM (
				 SELECT DISTINCT "zf"."idGrupyPrzetargowej", "k"."nazwa", ("f"."nrFaktury" || \' \' || "d"."nazwa" || \' - \' || (CASE "z"."poziom" WHEN 1 THEN \'Łatwe\'  WHEN 2 THEN \'Trudne\'  WHEN 3 THEN \'Bardzo trudne\' END)) as "zlecenie", "t"."kwotaKary",to_char("zf"."czasZakonczenia", \'YYYY/MM/DD\') as "czasZakonczenia", 1 as "przetarg", "zf"."id"
					FROM (
						SELECT "zf"."idGrupyPrzetargowej", "o"."wartosc" as "kwotaKary"
						FROM "ZlecenieFirmy" "zf"
						LEFT JOIN "Zlecenie" "z" ON "z"."id" = "zf"."idZlecenia"
						LEFT JOIN "Oplaty" "o" ON "o"."id" = "zf"."idOplaty"
						WHERE "zf"."id" IN (SELECT DISTINCT "zf"."id" FROM "PrzetargFirma" "pf"
						/* Dołączamy zlecenia które zostały źle rozwiązane oraz są przetargowe oraz dla tych przetargów ilość źle rozwiązanych została przekroczona */
						RIGHT JOIN (
							SELECT *
							FROM "ZlecenieFirmy" "t"
							WHERE "t"."czasPodjecia" IS NOT NULL AND "t"."czasZakonczenia" IS NOT NULL AND "t"."odpowiedz" IS NULL
						) "a" ON "a"."idGrupyPrzetargowej" = "pf"."idGrupy" AND (SELECT COUNT(*) FROM "ZlecenieFirmy" WHERE "idGrupyPrzetargowej" = "pf"."idGrupy") > (SELECT case when (SELECT "wartosc" FROM "ParametryGry" WHERE "nazwa" = \'PRZETARG_MAX_ZLE_ROZWIAZANYCH_ZADAN\') IS NULL then 1 else (SELECT TO_NUMBER("wartosc") FROM "ParametryGry" WHERE "nazwa" = \'PRZETARG_MAX_ZLE_ROZWIAZANYCH_ZADAN\') end as "maxFailures" FROM DUAL)
						LEFT JOIN "ZlecenieFirmy" "zf" ON "zf"."idGrupyPrzetargowej" = "pf"."idGrupy"
						WHERE "pf"."idFirmy" = '.$companyId.'
					) /*GROUP BY "zf"."idGrupyPrzetargowej"*/
					) "t"
					JOIN "ZlecenieFirmy" "zf" ON "zf"."idGrupyPrzetargowej" = "t"."idGrupyPrzetargowej"
					LEFT JOIN "Kontrahent" "k" ON "k"."id" = "zf"."idKontrahenta"
					LEFT JOIN "Zlecenie" "z" ON "z"."id" = "zf"."idZlecenia"
					LEFT JOIN "Faktury" "f" ON "f"."id" = "zf"."idFaktury"
					LEFT JOIN "Dziedzina" "d" ON "d"."id" = "z"."idDziedziny")
				)';

		$bookNotesArray = Yii::app()->db->createCommand($sql)->queryAll();
		return $bookNotesArray;
	}

	protected function payPenalty()
	{
		$this->idOplaty = $this->idFirmy0->makePayment($this->idZlecenia0->kwotaKary,
			$this->idKontrahenta, 'Kara za niewykonanie zlecenia ' . $this->nrUmowy . '.');
		$this->idFirmy0->save(false);
	}

	protected function transferPoints()
	{
		$taskScore = $this->idZlecenia0->scoreForOrder;
		$dziedzinaId = $this->idZlecenia0->idDziedziny;
		$companyId = Yii::app()->user->getState("id_firmy");

		DziedzinaFirmy::add($companyId, $dziedzinaId, $taskScore);

		if ($this->idUcznia)
			DziedzinaUzytkownika::add($this->idUcznia, $dziedzinaId, $taskScore);
		else if ($this->idPracownika)
			DziedzinaPracownika::add($this->idPracownika, $dziedzinaId, $taskScore);
	}

	public function finish()
	{
		if ($this->idPracownika)
		{
			if (empty($this->czasZakonczenia))
				$this->worker->resolveTask($this, true);
		}
		else
		{
			if (empty($this->idUcznia))
				$this->idUcznia = Yii::app()->user->id;
			$this->idOdpowiedzi = $this->idZlecenia0->checkAnswer($this->odpowiedz);
			$this->czasZakonczenia = new CDbExpression('SYSDATE');
		}

		$result = empty($this->idOdpowiedzi) ? self::TASK_FAILED : self::TASK_SUCCESS;

		$transaction = Yii::app()->db->beginTransaction();
		try
		{
			if ($result)
			{
				if (empty($this->idGrupyPrzetargowej))
					$this->transferPayment();

				$this->transferPoints();
			}
			else if (empty($this->idGrupyPrzetargowej))
				$this->payPenalty();

			$this->save(false);
			$this->refresh();

			if ($this->idGrupyPrzetargowej)
			{
				$this->tenderGroup->checkStatus();

				$tenderPartialPayment = (int)ParametryGry::getValue('PRZETARG_OPLATA_CZASTKOWA', 1);

				if ($result && $tenderPartialPayment)
					$this->idFaktury = $this->tenderGroup->transferPayment();
			}

			$transaction->commit();
		}
		catch (Exception $e)
		{
			$transaction->rollback();
			throw $e;
		}

		return $result;
	}

	public function getExpireationTime()
	{
		return empty($this->czasPodjecia) ? 0 : strtotime($this->czasPodjecia)
			+ ParametryGry::getValue('ZLECENIE_ILOSC_DNI', 7)*3600*24;
	}

	public function checkStatus($now = null)
	{
		if (empty($now)) $now = time();

		if (!empty($this->czasZakonczenia))
		{
			return $this->idOdpowiedzi == null ? self::TASK_FAILED : self::TASK_SUCCESS;
		}
		else if (!empty($this->czasPodjecia))
		{
			if (!empty($this->czasRozpoczecia))
			{
				if (strtotime($this->czasRozpoczecia) + (int)$this->idZlecenia0->czas < $now)
				{
					return $this->finish();
				}
			}
			else if ($this->expireationTime < $now)
			{
				return $this->finish();
			}
			else if ($this->idPracownika)
			{
				$result = $this->worker->resolveTask($this);
				if ($result !== self::TASK_NOTSET)
					return $this->finish();
			}
		}

		//zlecenie nie zostalo jeszcze roziwazane
		return self::TASK_NOTSET;
	}

	public function getNrUmowy()
	{
		srand((int)$this->id * 13 + (int)$this->idZlecenia * 7 + (int)$this->idFirmy * 27);
		$result = '';
		$chars = array('A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M',
				'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z');
		for ($i = 0; $i < 4; $i++)
			$result .= $chars[rand() % count($chars)];
		srand(mt_rand());
		return $result . '/' . date('m/Y', strtotime($this->czasPodjecia));
	}

	public function getCzasPodjeciaYmd()
	{
		return date('Y/m/d', strtotime($this->czasPodjecia));
	}

	public static function listDataProvider($studentId=null, $companyId=null)
	{
		$criteria = array(
			'with'=>array('kontrahent', 'idZlecenia0.dziedzina', 'idZlecenia0.odpowiedziZlecenia'),
		);
		if (!empty($studentId))
		{
			$criteria['condition'] = '"t"."idUcznia" = :uczenId and "t"."czasZakonczenia" is not null';
			$criteria['params'] = array(':uczenId' => $studentId);
		}
		else if (!empty($companyId))
		{
			$criteria['with'][] = 'uczen';
			$criteria['condition'] = '"t"."idFirmy" = :companyId and "t"."czasZakonczenia" is not null';
			$criteria['params'] = array(':companyId' => $companyId);
		}
		return new CActiveDataProvider('ZlecenieFirmy', array(
			'criteria' => $criteria,
			'pagination'=>array(
				'pageSize'=>10,
			),
			'sort'=>array(
				'defaultOrder'=>'"t"."czasZakonczenia" DESC',
				'attributes'=>array(
					'dziedzina'=>array(
						'asc'=>'"idZlecenia0"."idDziedziny"',
						'desc'=>'"idZlecenia0"."idDziedziny" DESC',
					),
					'kategoria'=>array(
						'asc'=>'"idZlecenia0"."kategoria"',
						'desc'=>'"idZlecenia0"."kategoria" DESC',
					),
					'poziom'=>array(
						'asc'=>'"idZlecenia0"."poziom"',
						'desc'=>'"idZlecenia0"."poziom" DESC',
					),
					'*',
					),
        ),
			)
		);
	}

	public function canStudentDoTask($studentId)
	{
		return (!empty($this->idUcznia) && $this->idUcznia == $studentId) ||
			!empty($this->idGrupyPrzetargowej);
	}

	public function getIntervalString()
	{
		return $this->czasZakonczenia
			? 'Zakończono ' . StringUtils::timeIntervalString($this->czasZakonczenia) . '.'
			: 'Koniec za ' . StringUtils::timeIntervalString($this->expireationTime) . '.';
	}

	public function getAssignedWorker()
	{
		if ($this->idUcznia)
			return 's' . $this->idUcznia;
		else if ($this->idPracownika)
			return 'w' . $this->idPracownika;
		else
			return null;
	}

	public function getAssignedWorkerName()
	{
		if ($this->idUcznia)
			return $this->uczen->imie . ' ' . $this->uczen->nazwisko;
		else if ($this->idPracownika)
			return $this->worker->imie . ' ' . $this->worker->nazwisko;
		else
			return null;
	}

	public function assignWorker($workerId, $tasksPerWorker = null, $returnEstimation = true)
	{
		if ($this->idGrupyPrzetargowej || empty($this->idFirmy))
			throw new Exception('Nie można przypisać pracownika do tego zlecenia.');

		if (empty($tasksPerWorker))
			$tasksPerWorker = Firma::getTasksPerWorker($this->idFirmy);

		$worker = Pracownik::model()->find(array(
			'condition' => '"t"."id" = :workerId and pf."idFirmy" = :companyId and
				pf."dataZwolnienia" is null',
			'join' => 'left join "PracownikFirmy" pf on pf."idPracownika" = "t"."id"',
			'params' => array(
				':companyId' => $this->idFirmy,
				':workerId' => $workerId,
			)
		));
		if (empty($worker))
			throw new Exception('Pracownik nie jest zatrudniony w twojej firmie.');

		$activeTasksCount = (int)Yii::app()->db->createCommand('
			select count(*) from "ZlecenieFirmy" zf
			where zf."idPracownika" = :workerId and zf."czasPodjecia" is not null and zf."idFirmy" = :companyId and zf."czasPodjecia" >= (select "czasRozpoczecia" from (
				select * from "Tura" "t" where "t"."idKlasy" = (select "idKlasy" from "Firma" where "id" = :companyId) order by "t"."czasRozpoczecia" DESC
			) where rownum <= 1)
		')->queryScalar(array(
			':workerId' => $workerId,
			':companyId' => $this->idFirmy
		));
		if ($activeTasksCount >= $tasksPerWorker)
			throw new Exception('Pracownik nie może podjąć się większej ilości zleceń.');

		$this->idPracownika = $workerId;
		$this->czasPrzypisania = new CDbExpression('SYSDATE');

		if ($returnEstimation)
			return $worker->getTaskEstimation($this->idZlecenia0);
	}

	public function assignStudent($studentId, $tasksPerWorker = null)
	{
		if ($this->idGrupyPrzetargowej || empty($this->idFirmy))
			throw new Exception('Nie można przypisać ucznia do tego zlecenia.');

		if (empty($tasksPerWorker))
			$tasksPerWorker = Firma::getTasksPerWorker($this->idFirmy);

		if (!Uzytkownik::isCompanyOwner($studentId, $this->idFirmy))
			throw new Exception('Uczeń nie jest w twoim zespole.');

		//sprawdz czy ma przypisane zadania
		$activeTasksCount = (int)Yii::app()->db->createCommand('
			select count(*) from "ZlecenieFirmy" zf
			where zf."idUcznia" = :studentId and zf."czasPodjecia" is not null and zf."idFirmy" = :companyId and zf."czasPodjecia" >= (select "czasRozpoczecia" from (
				select * from "Tura" "t" where "t"."idKlasy" = (select "idKlasy" from "Firma" where "id" = :companyId) order by "t"."czasRozpoczecia" DESC
			) where rownum <= 1)
		')->queryScalar(array(
			':studentId' => $studentId,
			':companyId' => $this->idFirmy
		));
		if ($activeTasksCount >= $tasksPerWorker)
			throw new Exception('Uczeń nie może podjąć się większej ilości zleceń.');

		$this->idUcznia = $studentId;
		$this->czasPrzypisania = new CDbExpression('SYSDATE');
	}
}
